import { jsx } from "react/jsx-runtime";
import * as PopoverPrimitive from "@radix-ui/react-popover";
import { useContainer } from "@tldraw/editor";
import { useMenuIsOpen } from "../../hooks/useMenuIsOpen.mjs";
function TldrawUiPopover({ id, children, onOpenChange, open }) {
  const [isOpen, handleOpenChange] = useMenuIsOpen(id, onOpenChange);
  return /* @__PURE__ */ jsx(
    PopoverPrimitive.Root,
    {
      onOpenChange: handleOpenChange,
      open: open || isOpen,
      children: /* @__PURE__ */ jsx("div", { className: "tlui-popover", children })
    }
  );
}
function TldrawUiPopoverTrigger({ children }) {
  return /* @__PURE__ */ jsx(PopoverPrimitive.Trigger, { asChild: true, dir: "ltr", children });
}
function TldrawUiPopoverContent({
  side,
  children,
  align = "center",
  sideOffset = 8,
  alignOffset = 0
}) {
  const container = useContainer();
  return /* @__PURE__ */ jsx(PopoverPrimitive.Portal, { container, children: /* @__PURE__ */ jsx(
    PopoverPrimitive.Content,
    {
      className: "tlui-popover__content",
      side,
      sideOffset,
      align,
      alignOffset,
      dir: "ltr",
      children
    }
  ) });
}
export {
  TldrawUiPopover,
  TldrawUiPopoverContent,
  TldrawUiPopoverTrigger
};
//# sourceMappingURL=TldrawUiPopover.mjs.map
